﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="EditProject.aspx.cs" Inherits="Pectra.Forms.FrontEnd.Host.Web.v2.EditProject" %>


<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="X-UA-Compatible" content="IE=Edge" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>Proyectos de Aplicaciones</title>
    <script src="../Includes/Bootstrap/js/jquery-3.2.1.min.js"></script>

    <!--Bootstrap-->
    <link type="text/css" href="../Includes/Bootstrap/css/bootstrap.min.css" rel="stylesheet" />
    <link type="text/css" href="../Includes/Site.css" rel="stylesheet" />
    <script type="text/javascript" src="../Includes/Bootstrap/js/bootstrap.min.js"></script>

    <!--DataTables-->
    <link type="text/css" href="~/Includes/DataTables/css/dataTables.bootstrap.min.css" rel="stylesheet" />
    <link type="text/css" href="~/Includes/DataTables/css/responsive.bootstrap.min.css" rel="stylesheet" />
    <link type="text/css" href="~/Includes/DataTables/css/select.bootstrap.min.css" rel="stylesheet" />
    <script type="text/javascript" src="../Includes/Scripts/DataTables/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.bootstrap.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.responsive.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/responsive.bootstrap.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.select.min.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.lang.js"></script>
    <script type="text/javascript" src="../Includes/Scripts/DataTables/dataTables.buttons.min.js"></script>

    <!--Font-awsome-->
    <link href="../Includes/Bootstrap/css/font-awesome.min.css" rel="stylesheet" />

    <!--Alert-->
    <link type="text/css" rel="stylesheet" href="Css/alert.css" />
    <script type="text/javascript" src="Scripts/alert.js"></script>
    <script type="text/javascript" src="Scripts/ee.min.js"></script>

    <!--Moment-->
    <script type="text/javascript" src="../Includes/Scripts/moment-with-locales.min.js"></script>

    <!-- EditProject files -->
    <link type="text/css" rel="stylesheet" href="Css/editproject.css?a" />
    <script type="text/javascript" src="Scripts/editproject.js?c"></script>

    <!--Bootbox-->
    <script type="text/javascript" src="../Includes/Bootstrap/js/bootbox.js"></script>

    <script>
        var keyAdmin = 0;
        $(document).ready(function () {
            <%if (EsAdministrador)
        { %>
            keyAdmin = 1;
            <% } %>
            moment.locale('<%=System.Threading.Thread.CurrentThread.CurrentCulture.Name%>');
            initializeEditProject();
        });

        function isKeyAdmin() {
            return keyAdmin;
        }
    </script>


</head>



<body>
    <form id="form1" runat="server">

        <!-- Progreso -->
        <div class="modal fade in" id="msgProcessing" style="display: block; background-color: rgba(0, 0, 0, 0.3)">
            <div class="modal-dialog" style="margin-top: 239px;">
                <div class="modal-content rounded" style="background-color: white; -webkit-box-shadow: none; -moz-box-shadow: none; -o-box-shadow: none; border: none; text-align: center;" id="modal-content">
                    <div class="modal-body" style="text-align: center; display: inline-block; border: 0px;">
                        <span style="font-size: 40px; vertical-align: middle;" class='fa fa-gear fa-spin' ondblclick="eeshow()"></span>
                        <span style="font-size: 20px; vertical-align: middle; margin-left: 10px" id="lblProcesandoSolicitud">Cargando....</span>
                    </div>
                    <img width="40px" style="display: none" id="eei" />
                    <div class="modal-body" style="text-align: center; display: none; border: 0px;">
                        <span>El proceso puede durar varios minutos</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="navbar navbar-default navbar-fixed-top topnav" role="navigation">
            <div class="container topnav">
                <div class="navbar-header">
                    <div class="img-responsive img-nav-header">
                        <div style="float: left">
                            <img src="../Images/App.gif" />
                        </div>
                        <div style="float: left; vertical-align: middle;">
                            <label class="label-title">Pectra Forms</label>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.container -->
        </nav>

        <!-- modal Proceso -->
        <div class="modal fade" id="mdlFileUpload" tabindex="-1" role="dialog" aria-labelledby="mdlLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" aria-hidden="true" onclick="$('#mdlFileUpload').modal('hide');" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="mdlLabel">Adjuntar Proceso de Pectra</h4>
                    </div>
                    <div class="modal-body">
                        <div>
                            <div class="form-group ">
                                <label for="usr">Archivo:</label>
                                <input type="text" class="form-control" id='txtFileUploadName' readonly="readonly" runat="server" />
                            </div>
                            <div class="form-group">
                                <div style="width: 100%; position: relative;">
                                    <a class='btn btn-primary' href='javascript:;' style="width: 100%;">Seleccione un archivo
                                    <input type="file" name="fileToUpload" id="fileToUpload" style='width: 100%; height: 35px; cursor: pointer; position: absolute; z-index: 2; top: 0; left: 0; filter: alpha(opacity=0); -ms-filter: "progid:DXImageTransform.Microsoft.Alpha(Opacity=0)"; opacity: 0; background-color: transparent; color: transparent;' size="40" onchange='asignarNombreArchivo(this)' />
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary" onclick="adjuntarProceso(); $('#mdlFileUpload').modal('hide');">Aceptar</button>
                        <button type="button" class="btn btn-default" onclick="$('#mdlFileUpload').modal('hide');">Cancelar</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- modal Conectar BD Server -->
        <div class="modal fade" id="mdlBDServer" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" aria-hidden="true" onclick="$('#mdlBDServer').modal('hide');"><span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title" id="mdlLabelBDServer">Configurar Servidor de Base de Datos</h4>
                    </div>
                    <div class="modal-body">
                        <div>
                            <div class="form-group ">
                                <label for="txtSQLServer">Nombre del Servidor</label>
                                <input type="text" class="form-control" id="txtSQLServer" runat="server" />
                            </div>
                            <div class="form-group ">
                                <label for="txtSQLAutenticacion">Autenticación</label>
                                <br />
                                <input type="radio" name="txtSQLAutenticacion" id="txtSQLAutenticacion_integrada" value="txtSQLAutenticacion_integrada" runat="server" onclick="habilitarUP(false)" /><label for="txtSQLAutenticacion_integrada">&nbsp;Usar la seguridad integrada de Windows</label>
                                <br />
                                <input type="radio" name="txtSQLAutenticacion" id="txtSQLAutenticacion_userpass" value="txtSQLAutenticacion_userpass" runat="server" onclick="habilitarUP(true)" /><label for="txtSQLAutenticacion_userpass">&nbsp;Usar un nombre de usuario y una contraseña específicos</label>
                            </div>
                            <div class="form-group">

                                <label for="txtSQLUserId">Nombre de Usuario</label>
                                <input type="text" class="form-control" id="txtSQLUserId" runat="server" />

                            </div>
                            <div class="form-group ">
                                <label for="txtSQLUserPassword">Contraseña</label>
                                <input name="txtSQLUserPassword" class="form-control hidden-control typed" id="txtSQLUserPassword" aria-invalid="false" aria-required="true" spellcheck="false" required="" runat="server"
                                    type="password" maxlength="100" autocomplete="off" data-name="txtSQLUserPassword" />
                                <input type="hidden" name="hdnSQLUserPassword" id="hdnSQLUserPassword" runat="server" />
                                <i class="fa fa-eye fa-1x" id="iSQLUserPassword" style="float: right; cursor: pointer; margin-top: -24px; margin-right: 10px"></i>
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary btn-ok" onclick="dbConectar(); ">Aceptar</button>
                        <button type="button" class="btn btn-default" onclick="$('#mdlBDServer').modal('hide');">Cancelar</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pantalla Principal -->
        <div class="mainContent">

            <div class="container bootstrap snippet" style="max-width: 500px; right: 10px; float: right; position: fixed;">
                <div class="alert alert-success alert-white rounded" id="alertContainer" style="display: none; z-index: 999999;">
                    <button type="button" aria-hidden="true" class="close" onclick="$('#alertContainer').hide();">×</button>
                    <div class="icon">
                        <i class="fa fa-check" id="alertI"></i>
                    </div>
                    <div id="alertText"></div>

                </div>
            </div>

            <div class="container">

                <div style="display: none">
                    <input type="text" id="txtTrxId" runat="server" />
                    <input type="text" id="txtUsId" runat="server" />
                    <input type="text" id="txtProyectoId" runat="server" />
                    <input type="text" id="txtProcesoId" runat="server" />
                    <input type="text" id="txtOrigenDeDatosId" runat="server" />
                    <input type="text" id="txtOrigenDeDatos" runat="server" />
                    <input type="text" id="txtAtributosDeTablas" runat="server" />
                    <input type="text" id="txtAtributosDePectra" runat="server" />
                    <input type="text" id="txtActividades" runat="server" />
                    <input type="text" id="DatosCambiados" runat="server" />
                </div>

                <!--Datos del Proyecto -->
                <div class="panel panel-blue panel-custom">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <a style="cursor: pointer" data-toggle="collapse" data-target="#section1">Datos del Proyecto
                            </a>
                        </h3>
                    </div>
                    <div id="section1" class="panel-body panel-collapse in">

                        <!-- Proyecto -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-2" data-group-key="txtProyecto">
                                <label class="control-label">Proyecto</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtProyecto">
                                <input type="text" id="txtProyectoName" runat="server" class="form-control" maxlength="100" />
                            </div>
                            <div class="col-sm-2" data-group-key="txtProyecto" style="text-align: right">
                                <button type="button" class="btn btn-info btn-block" id="btnCrearProyecto" runat="server" onclick="crearProyecto()">
                                    <i class="fa fa-edit fa-1x" id="iuploadingprogress" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnaddProyecto">Crear</span></button>
                            </div>
                        </div>

                        <!-- Proceso -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-2" data-group-key="txtProceso">
                                <label for="usr">Proceso</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtProceso">
                                <div class="input-group margin-bottom-sm">
                                    <input class="form-control" type="text" readonly="readonly" id="lblFileUploadName" runat="server" />
                                    <span id="btndownloadEnabled" runat="server" class="input-group-addon btn" style="border-color: rgb(46, 109, 164); color: rgb(255, 255, 255); background-color: rgb(51, 122, 183);" onclick="descargarProceso()"><i class="fa fa-download"></i></span>
                                    <span id="btndownloadDisabled" runat="server" class="input-group-addon" aria-disabled="true" style="display: none; cursor: not-allowed"><i class="fa fa-download"></i></span>
                                </div>
                            </div>

                            <div class="col-sm-2" data-group-key="txtProceso" style="text-align: right">
                                <button type="button" class="btn btn-info btn-block" id="btnCrearProceso" runat="server" data-toggle='modal' data-target='#mdlFileUpload'>
                                    <i class="fa fa-upload fa-1x" id="iuploadingprogress2" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnaddfileUploadText">Adjuntar </span>
                                </button>
                            </div>
                        </div>

                        <!-- BD Server -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-2" data-group-key="txtBDServer">
                                <label class="control-label">Servidor de Datos</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtBDServer">
                                <input type="text" class="form-control" id='lblSQLServer' readonly="readonly" runat="server" />
                            </div>
                            <div class="col-sm-2" data-group-key="txtProceso" style="text-align: right">
                                <button type="button" class="btn btn-info btn-block" id="btnConectarBDServer" runat="server" data-toggle='modal' data-target='#mdlBDServer'>
                                    <i class="fa fa-plug fa-1x" id="iuploadingprogress3" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnConfigurarBDServer">Conectar </span>
                                </button>
                            </div>
                        </div>

                        <!-- Base de Datos-->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-2" data-group-key="txtBD">
                                <label class="control-label">Base de Datos</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtBD">
                                <asp:DropDownList class="form-control" ID="cboDataBases" runat="server" Style="display: none"></asp:DropDownList>
                                <input type="text" class="form-control" id='lblBDName' readonly="readonly" runat="server" />
                            </div>
                            <div class="col-sm-2" data-group-key="txtBD" style="text-align: right">
                            </div>
                        </div>

                        <br />
                        <!-- Generar BackEnd-->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-5" data-group-key="txtGB"></div>
                            <div class="col-sm-2" data-group-key="txtGB" style="text-align: center">
                                <button type="button" class="btn btn-primary btn-block" id="btnGenerarBackEnd" runat="server" onclick="dbGenerarBackEnd(false)">
                                    <i class="fa fa-gear fa-spin fa-1x" id="iconfigurarDatosProgress" style="display: none; float: left; margin-top: 2px;"></i>
                                    <i class="fa fa-server fa-1x" id="iconfigurarDatos" style="float: left; margin-top: 2px;"></i>
                                    <span id="spanConfigurarBD">Generar BackEnd </span>
                                </button>
                            </div>
                            <div class="col-sm-5" data-group-key="txtGB"></div>
                        </div>

                        <div class="clearfix"></div>

                    </div>
                </div>

                <!--Diccionario de Datos-->
                <div class="panel panel-blue panel-custom" id="divDD" runat="server">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <a style="cursor: pointer" data-toggle="collapse" data-target="#section2">Diccionario de Datos
                            </a>
                        </h3>
                    </div>
                    <div id="section2" class="panel-body panel-collapse in">

                        <!-- tablas -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-2" data-group-key="txtTablas">
                                <label class="control-label">Tablas</label>
                            </div>
                            <div class="col-sm-6" data-group-key="txtTablas">
                                <asp:DropDownList ID="cboTablas" class="form-control" runat="server" onchange="FiltrarAtributos()"></asp:DropDownList>
                            </div>
                        </div>

                        <!-- grilla de atributos -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-12" data-group-key="aAtributeMapping">
                                <div class="panel panel-default" id="pnlAtributeMapping" style="margin: 10px;">
                                    <div class="panel-heading">Atributos </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <table id="tableAtributeMapping" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                        <div class="row" style="text-align: right; padding-right: 20px; padding-bottom: 5px;">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- botones -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-10" data-group-key="txtGuardarDD"></div>
                            <div class="col-sm-2" data-group-key="txtGuardarDD" style="text-align: right">
                                <button type="button" class="btn btn-primary btn-block" id="btnGuardarDD" runat="server" onclick="guardarMapeo()">
                                    <i class="fa fa-save fa-1x" id="iDiccionarioDatos" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnGuardarDiccionarioDatos">Guardar</span></button>
                            </div>
                        </div>
                    </div>
                </div>

                <!--Actividades-->
                <div class="panel panel-blue panel-custom" id="divActividades" runat="server">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <a style="cursor: pointer" data-toggle="collapse" data-target="#section3">Actividades del Proceso
                            </a>
                        </h3>
                    </div>
                    <div id="section3" class="panel-body panel-collapse in">

                        <!-- grilla de Actividades -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-12" data-group-key="aActivities">
                                <div class="panel panel-default" id="pnlActivities" style="margin: 10px;">
                                    <div class="panel-heading" style="display: none">Actividades</div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <table id="tableActivities" class="table table-hover dt-responsive" cellspacing="0" width="100%">
                                                <thead>
                                                    <tr>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- botones -->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-10" data-group-key="txtNuevaActividad"></div>
                            <div class="col-sm-2" data-group-key="txtNuevaActividad" style="text-align: right">
                                <button type="button" class="btn btn-primary btn-block" id="btnNuevaActividad" runat="server" onclick="NuevaActividad()">
                                    <i class="fa fa-plus-circle fa-1x" id="iNuevaActividad" style="float: left; margin-top: 2px;"></i>
                                    <span id="btniNuevaActividad">Nueva Actividad</span></button>
                            </div>
                        </div>

                    </div>
                </div>

                <!--Generacion de la app -->
                <div class="panel panel-blue panel-custom" id="divGeneracionApp" runat="server">
                    <div class="panel-heading">
                        <h3 class="panel-title">
                            <a style="cursor: pointer" data-toggle="collapse" data-target="#section4">Generación de Aplicación
                            </a>
                        </h3>
                    </div>
                    <div id="section4" class="panel-body panel-collapse in">

                        <!-- Ultima descarga -->
                        <div class="row" style="margin-bottom: 8px; display: none" id="divUltimaDescarga">
                            <div class="col-sm-2" data-group-key="txtUltimaApp">
                                <label class="control-label">&Uacute;ltima Generación</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtUltimaApp">
                                <input type="text" id="txtUltimaVersionGenerada" readonly="readonly" runat="server" class="form-control" />
                            </div>
                            <div class="col-sm-2" data-group-key="txtUltimaApp" style="text-align: right">
                                <button type="button" class="btn btn-info btn-block" id="Button3" runat="server" onclick="descargarUltimaGeneracion()">
                                    <i class="fa fa-download fa-1x" id="idownloadprogress" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnidownload">Descargar</span></button>
                            </div>
                        </div>


                        <%if (EsAdministrador)
                            { %>
                        <!-- Ultima log Pectra Form -->
                        <div class="row" style="margin-bottom: 8px; display: none" id="divUltimologForm">
                            <div class="col-sm-2" data-group-key="txtUltimologForm">
                                <label class="control-label">&Uacute;ltimo Log de Form</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtUltimologForm">
                                <input type="text" id="txtUltimologForm" readonly="readonly" runat="server" class="form-control" />
                            </div>
                            <div class="col-sm-2" data-group-key="txtUltimologForm" style="text-align: right">
                                <button type="button" class="btn btn-info btn-block" id="Button1" runat="server" onclick="descargarUltimaLog(1)">
                                    <i class="fa fa-download fa-1x" id="idownloadprogress1" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnidownload1">Descargar</span></button>
                            </div>
                        </div>

                        <!-- Ultima log FrontEnd -->
                        <div class="row" style="margin-bottom: 8px; " id="divUltimologFrontEnd">
                            <div class="col-sm-2" data-group-key="txtUltimologFrontEnd">
                                <label class="control-label">Log de Web</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtUltimologFrontEnd">
                                <input type="text" id="txtUltimologFrontEnd" readonly="readonly" runat="server" class="form-control" />
                            </div>
                            <div class="col-sm-2" data-group-key="txtUltimologFrontEnd" style="text-align: right">
                                <button type="button" class="btn btn-info btn-block disabled" id="btnUltimologFrontEnd" runat="server" onclick="descargarUltimaLog(2)" aria-disabled="true">
                                    <i class="fa fa-download fa-1x" id="idownloadprogress2" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnidownload2">Descargar</span></button>
                            </div>
                        </div>

                        <!-- Ultima log API -->
                        <div class="row" style="margin-bottom: 8px;" id="divUltimologAPI">
                            <div class="col-sm-2" data-group-key="txtUltimologAPI">
                                <label class="control-label">Log de API</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtUltimologAPI">
                                <input type="text" id="txtUltimologAPI" readonly="readonly" runat="server" class="form-control" />
                            </div>
                            <div class="col-sm-2" data-group-key="txtUltimologAPI" style="text-align: right">
                                <button type="button" class="btn btn-info btn-block disabled" id="btnUltimologAPI" runat="server" onclick="descargarUltimaLog(3)" aria-disabled="true">
                                    <i class="fa fa-download fa-1x" id="idownloadprogress3" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnidownload3">Descargar</span></button>
                            </div>
                        </div>

                        <!-- Ultima log PWA -->
                        <div class="row" style="margin-bottom: 8px;" id="divUltimologPWA">
                            <div class="col-sm-2" data-group-key="txtUltimologPWA">
                                <label class="control-label">Log de PWA</label>
                            </div>
                            <div class="col-sm-8" data-group-key="txtUltimologPWA">
                                <input type="text" id="txtUltimologPWA" readonly="readonly" runat="server" class="form-control" />
                            </div>
                            <div class="col-sm-2" data-group-key="txtUltimologPWA" style="text-align: right">
                                <button type="button" class="btn btn-info btn-block disabled" id="btnUltimologPWA" runat="server" onclick="descargarUltimaLog(4)" aria-disabled="true">
                                    <i class="fa fa-download fa-1x" id="idownloadprogress4" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnidownload4">Descargar</span></button>
                            </div>
                        </div>
                        <% } %>


                        <br />
                        <!-- Generar app-->
                        <div class="row" style="margin-bottom: 8px">
                            <div class="col-sm-5" data-group-key="txtGApp"></div>
                            <div class="col-sm-2" data-group-key="txtGApp" style="text-align: right">
                                <button type="button" class="btn btn-primary btn-block" id="btnGenerarApp" runat="server" onclick="dbGenerarBackEnd(true)">
                                    <i class="fa fa-gear fa-1x" id="iGenerarApp" style="float: left; margin-top: 2px;"></i>
                                    <span id="btnActivities">Generar App</span></button>
                            </div>
                            <div class="col-sm-5" data-group-key="txtGApp"></div>
                        </div>

                        <div class="clearfix"></div>

                    </div>
                </div>
                <!-- Botonera inferior -->
                <div class="panel panel-custom">
                    <div class="row" style="margin-bottom: 8px">
                        <div class="col-sm-8" data-group-key="txtGuardarActivities"></div>

                        <div class="col-sm-2" data-group-key="txtVolver" style="text-align: right">
                            <button type="button" class="btn btn-block" id="btnBackup" runat="server" onclick="respaldar()">
                                <i class="fa fa-database fa-1x" id="iBackup" style="float: left; margin-top: 2px;"></i>
                                <span id="lblBackup">Respaldar</span></button>
                        </div>
                        <div class="col-sm-2" data-group-key="txtVolver" style="text-align: right">
                            <button type="button" class="btn btn-block" id="txtVolver" runat="server" onclick="retornar()">
                                <i class="fa fa-arrow-circle-left fa-1x" id="iVolver" style="float: left; margin-top: 2px;"></i>
                                <span id="lblVolver">Volver</span></button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Footer -->
        <footer style="margin-top: 20px;">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <p class="copyright text-muted small">Powered by Pectra Forms - Copyright &copy; <%= System.DateTime.Today.Year %></p>
                    </div>
                </div>
            </div>
        </footer>
    </form>
</body>
</html>
